--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An Actor (not to be confused with a Mobile Actor) is an object that can be cloned and that has an inventory. Creatures, NPCs, and containers are all considered actors.
--- 
--- It is standard for creatures and NPCs to be composed of an actor and a mobile actor, linked together with a reference.
--- @class tes3actor : tes3physicalObject, tes3object, tes3baseObject
--- @field actorFlags number *Read-only*. A number representing the actor flags. Truly a bit field.
--- @field barterGold number The actor's base barter gold amount. This is the amount of the barter gold an actor initially has, and also when barter gold is refreshed. The actor's current barter gold amount is held in `tes3mobileActor.barterGold`.
--- 
--- Barter gold is reset on talking to an actor if fBarterGoldResetDelay hours have passed since the last transaction. If you want to change the base amount, for example in an investment mod, you must edit the barterGold of the baseObject.
--- @field blood integer Friendly access to actor's blood type, in [0, 7] range. The available blood types are defined in the Morrowind.ini file, and assigned to the actor via the Construction Set.
--- @field cloneCount number *Read-only*. For base objects this is the number of clones that exist of this actor. For instances this is the ordinal number of the instance.
--- @field equipment tes3equipmentStack[] *Read-only*. The items currently equipped to the actor.
--- @field inventory tes3inventory|tes3itemStack[] *Read-only*. The items currently carried by the actor.
tes3actor = {}

--- Returns the combined value of all the items worn by the actor.
--- @param params tes3actor.getEquipmentValue.params This table accepts the following values:
--- 
--- `useDurability?`: boolean — *Default*: `false`. If true, damaged items will have a proportionally lower value.
--- @return number value The value of each equipped item added together.
function tes3actor:getEquipmentValue(params) end

---Table parameter definitions for `tes3actor.getEquipmentValue`.
--- @class tes3actor.getEquipmentValue.params
--- @field useDurability? boolean *Default*: `false`. If true, damaged items will have a proportionally lower value.

--- Checks if the actor has provided item equipped.
--- @param item tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string The item to perform a check for.
--- @param itemData? tes3itemData *Optional*. No description yet available.
--- @return boolean result No description yet available.
function tes3actor:hasItemEquipped(item, itemData) end

--- Checks if the actor will offer a service in dialogue. This an offer and may still be refused by dialogue checks. To also get the result of dialogue checks, use [`tes3.checkMerchantOffersService()`](https://mwse.github.io/MWSE/apis/tes3/#tes3checkmerchantoffersservice).
--- @param service tes3.merchantService Use one of the values in the [`tes3.merchantService.*`](https://mwse.github.io/MWSE/references/merchant-services/) table.
--- @return boolean result No description yet available.
function tes3actor:offersService(service) end

--- A callback function invoked when an inventory is closed. Typically not used outside of specific purposes. You may find `tes3.reference`'s `onCloseInventory()` to be more convenient to use.
--- @param reference tes3reference No description yet available.
function tes3actor:onInventoryClose(reference) end

--- Checks if the actor will buy and sell items of a given object type. e.g. `actor:tradesItemType(tes3.objectType.repairItem)`
--- @param objectType tes3.objectType Accepts values from [`tes3.objectType`](https://mwse.github.io/MWSE/references/object-types/) namespace.
--- @return boolean result No description yet available.
function tes3actor:tradesItemType(objectType) end

